/*
 * Copyright (C) 2021 Red Hat Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include "backends/native/meta-thread-impl.h"

#define META_TYPE_THREAD_IMPL_TEST (meta_thread_impl_test_get_type ())
G_DECLARE_FINAL_TYPE (MetaThreadImplTest, meta_thread_impl_test,
                      META, THREAD_IMPL_TEST,
                      MetaThreadImpl)

#define meta_assert_true_in_thread_impl(thread) \
  g_assert_true (meta_thread_is_in_impl_task (thread))
#define meta_assert_false_in_thread_impl(thread) \
  g_assert_false (meta_thread_is_in_impl_task (thread))
