/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation
 * All rights reserved.
 *
 * This file is part of the Gnome Library.
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
  @NOTATION@
 */

/* GnomeEntry widget - combo box with auto-saved history
 *
 * Author: Federico Mena <federico@nuclecu.unam.mx>
 */

#ifndef GNOME_ENTRY_H
#define GNOME_ENTRY_H


#include <glib.h>
#include <libgnome/gnome-defs.h>
#include "gnome-selector.h"


BEGIN_GNOME_DECLS


#define GNOME_TYPE_ENTRY            (gnome_entry_get_type ())
#define GNOME_ENTRY(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_ENTRY, GnomeEntry))
#define GNOME_ENTRY_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_ENTRY, GnomeEntryClass))
#define GNOME_IS_ENTRY(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_ENTRY))
#define GNOME_IS_ENTRY_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_ENTRY))
#define GNOME_ENTRY_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_ENTRY, GnomeEntryClass))


typedef struct _GnomeEntry        GnomeEntry;
typedef struct _GnomeEntryPrivate GnomeEntryPrivate;
typedef struct _GnomeEntryClass   GnomeEntryClass;

struct _GnomeEntry {
	GnomeSelector selector;

	/*< private >*/
	GnomeEntryPrivate *_priv;
};

struct _GnomeEntryClass {
	GnomeSelectorClass parent_class;
};


guint        gnome_entry_get_type         (void) G_GNUC_CONST;
GtkWidget   *gnome_entry_new              (const gchar *history_id);
GtkWidget   *gnome_entry_new_flags        (const gchar *history_id,
                                           guint32      flags);

/* for language bindings and subclassing, use gnome_entry_new */
void         gnome_entry_construct        (GnomeEntry  *gentry, 
                                           const gchar *history_id);

void         gnome_entry_construct_full   (GnomeEntry  *gentry,
                                           const gchar *history_id,
                                           const gchar *dialog_title,
                                           GtkWidget   *entry_widget,
                                           GtkWidget   *selector_widget,
                                           GtkWidget   *browse_dialog,
                                           guint32      flags);

#ifndef GNOME_EXCLUDE_DEPRECATED

GtkWidget   *gnome_entry_gtk_entry        (GnomeEntry  *gentry);

const gchar *gnome_entry_get_history_id   (GnomeEntry  *gentry);

void         gnome_entry_set_history_id   (GnomeEntry  *gentry,
					   const gchar *history_id);
const gchar *gnome_entry_get_history_id   (GnomeEntry  *gentry);

void         gnome_entry_set_max_saved    (GnomeEntry  *gentry,
					   guint        max_saved);
guint        gnome_entry_get_max_saved    (GnomeEntry  *gentry);

void         gnome_entry_prepend_history  (GnomeEntry  *gentry,
					   gboolean    save,
					   const gchar *text);
void         gnome_entry_append_history   (GnomeEntry  *gentry,
					   gboolean     save,
					   const gchar *text);
void         gnome_entry_load_history     (GnomeEntry  *gentry);
void         gnome_entry_save_history     (GnomeEntry  *gentry);
void         gnome_entry_clear_history    (GnomeEntry  *gentry);

#endif /* not GNOME_EXCLUDE_DEPRECATED */

END_GNOME_DECLS

#endif
